<?php
session_start();
include "../connection.php"; 

if (!isset($_SESSION['userid'])) {
    if (isset($_COOKIE['userid'])) {
        $_SESSION['userid'] = $_COOKIE['userid'];
    } else {
        header("Location: ../login.php");
        exit();
    }
}

// Fetch all offers with SIM names and area names
$sql = "
    SELECT adp.*, se.sim_name, d.dist_name 
	FROM all_drive_package adp 
	JOIN sim_entry se ON adp.offer_sim = se.sim_id
	JOIN district d ON adp.offer_area = d.dist_id
	WHERE adp.offer_type = 'Drive';

";
$result = mysqli_query($con, $sql);
$offers = [];
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $offers[] = $row;
    }
}

// Fetch all SIM names
$simSql = "SELECT * FROM sim_entry";
$simResult = mysqli_query($con, $simSql);
$sims = [];
if ($simResult) {
    while ($simRow = mysqli_fetch_assoc($simResult)) {
        $sims[] = $simRow;
    }
}

// Fetch all area names
$areaSql = "SELECT * FROM district";
$areaResult = mysqli_query($con, $areaSql);
$areas = [];
if ($areaResult) {
    while ($areaRow = mysqli_fetch_assoc($areaResult)) {
        $areas[] = $areaRow;
    }
}
?>

<?php include 'header-link.php' ?>

<main>

	<?php include 'top-bar.php' ?>

    <section>
        <div class="container mt-2 pb-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card custom-card">
                        <div class="card-body">
							
							<div class="text-center">
								<i class="profile-icon fa-solid fa-gift"></i>
							</div>
						
                            <h6 class="card-title text-center my-3"> ড্রাইভ অফার সমূহ </h6>

                            <div class="mb-3">
                                <select class="form-control text-center" name="SelectSim" id="categorySelect">
                                    <option value=""> --- সিম সিলেক্ট করুন --</option>
                                    <?php foreach ($sims as $sim): ?>
                                        <option value="<?php echo $sim['sim_id']; ?>"><?php echo $sim['sim_name']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <input type="text" class="form-control mb-4" id="searchInput" placeholder="অফার খুঁজুন..." onkeyup="filterOffers()">

                            <div class="offer-list" id="offerList">
                                <?php foreach ($offers as $offer): ?>
                                    <div class="offer-card mb-5 p-3" data-sim="<?php echo $offer['offer_sim']; ?>">
                                        <div class="row">
                                            <div class="col">
                                                <small class="fw-bold"> অফার: <?php echo $offer['offer_name']; ?></small><br>
                                                <small>মেয়াদ: <?php echo $offer['offer_meyad']; ?></small><br>
                                                <small> সিম: <?php echo $offer['sim_name']; ?> </small>
                                            </div>
                                            <div class="col text-end">
                                                <small class="fw-bold">মূল্য: <?php echo $offer['offer_amount']; ?> ৳ </small><br>
                                                <small>কমিশন: <?php echo $offer['offer_commision']; ?> ৳ </small><br>
                                                <small> বিভাগ: <?php echo $offer['dist_name']; ?></small>
                                            </div>
                                        </div>
                                        <div class="d-grid">
                                            <a href="drive-view.php?offer_id=<?php echo $offer['offer_id']; ?>" class="btn custom-button w-50 mx-auto">ক্রয় করুন</a>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

<script>
function filterOffers() {
    const searchInput = document.getElementById('searchInput').value.toLowerCase();
    const categorySelect = document.getElementById('categorySelect').value;
    const offerCards = document.querySelectorAll('.offer-card');

    offerCards.forEach(card => {
        const offerText = Array.from(card.querySelectorAll('small')).map(small => small.textContent.toLowerCase()).join(' ');
        const offerSim = card.getAttribute('data-sim');

        const matchesSearch = offerText.includes(searchInput);
        const matchesSim = categorySelect === "" || offerSim === categorySelect;

        if (matchesSearch && matchesSim) {
            card.style.display = '';
        } else {
            card.style.display = 'none';
        }
    });
}

// Event listener for the SIM select dropdown
document.getElementById('categorySelect').addEventListener('change', filterOffers);
</script>

</body>
</html>
